#include <cstring>
#include <string>

using std::string;

#include "rdr.h"

#ifdef WITH_ZLIB
string LineFetcherComp::getline() {
	if(!in) return "";

	// Note: This only reads the first 1024 characters of
	// a line.  Long lines in input will be broken up.
	// This should be more than sufficient for our needs,
	// but really does break the abstraction.
	char buf[1024];
	if(gzgets(in, buf, sizeof buf)) {
		// Strip \n (if any) from the end and return.  
		// If there's no \n, the input line was too long.
		int len = strlen(buf);
		if(buf[len-1] == '\n') --len;
		return string(buf, len);
	} else {
		// Treat any error as the end of stream.
		gzclose(in);
		in = NULL;
		return "";
	}
}
#endif

Reference TraceReader::read()
{
	// If we have a pending response, send that back.
	if(m_pend.type != Reference::None) {
		Reference ret(m_pend);
		m_pend.type = Reference::None;
		return ret;
	}

	// Read the lines.  Cast as a for instead of a while so that
	// reading the next line can be the increment, and continue
	// will run it.
	for(string line = m_fetcher->getline(); !m_fetcher->eof();
	    		line = m_fetcher->getline()) {
		// Not every line is a reference log entry.  Reject
		// some that don't have the right type of character
		// in the right places.
		if(line.length() < 13) continue;
		if(!isxdigit(line[3]) || !isxdigit(line[10]))
			continue;
			
		// Find the reference type and discard the record if it's
		// not recognized.
		bool is_update = false;
		Reference::type_t type;
		char typechar = line[0] == ' ' ? line[1] : line[0];
		switch(typechar) {
		case 'I':
			if(line[1] != ' ') continue;
			type = Reference::InstrFetch;
			break;
		case 'M':
			is_update = true;
			// Cases merge: No break here.
		case 'L':
			if(line[0] != ' ') continue;
			type = Reference::DataFetch;
			break;
		case 'S':
			if(line[0] != ' ') continue;
			type = Reference::Store;
			break;
		default:
			// Bad format
			continue;
		}

		// Find the comma that follows the address, and check format 
		// around that place.
		int comma = line.find(',');
		if(comma == string::npos || comma < 11 ||
		   comma >= line.length()-1)
			continue;
		if(!isxdigit(line[comma-1]) || !isdigit(line[comma+1]))
			continue;
		
		// Create the return reference.
		Reference ret(type, std::stoull(line.substr(3),nullptr,16),
			      std::stoi(line.substr(comma+1)));

		// If this is an update, we made the ret a fetch, and now
		// must make the corresponding store pending.
		if(is_update) {
			m_pend = ret;
			m_pend.type = Reference::Store;
		}

		return ret;
	}

	return Reference();
}
