/*
 * Test program for the reference reader.  Just reads the indicated file and
 * prints the output.  Uses the decompress mode if 
 *   It's compiled in
 *   The file name ends in .gz.
 */
#include <iostream>
#include <string>
#include <map>

using std::string;

#include <cstdlib>

#include "rdr.h"

/*
 * This loads the command line items into a map.  Items key=value are added
 * as map[key] = value, and others as map[x] = ".".
 * It's mostly here so you can steal it for the assignment.
 */
auto loadargs(int argc, char **argv){
	// Return this.
	std::map<string,string> ret;

	// Go through the arguments.
	while(argc--) {
		// Extract the next argument.
		string arg = *argv++;

		// Split on the = (if any) and enter into the map.
		int pos = arg.find('=');
		if(pos == string::npos) {
			ret[arg] = ".";
		} else {
			ret[arg.substr(0,pos)] = arg.substr(pos+1);
		}
	}

	return ret;
}


int main(int argc, char **argv){
	string progname = *argv++; argc--;
	if(argc == 0) {
		std::cout << "You must provide a file name to read."
			  << std::endl;
		exit(1);
	}
	string filename = *argv++; argc--;
	auto args = loadargs(argc, argv);
	
	std::cout << "=== " << filename << " ===" << std::endl;
	int numrec = 0;
	TraceReader rdr(filename);
	Reference r = rdr.read();
	int limit = 0;
	if(args["limit"] != "") limit = stoi(args["limit"]);
	while(!rdr.eof()) {
		std::cout << " " << r << std::endl;
		++numrec;
		if(limit && numrec >= limit) break;
		r = rdr.read();
	}

	if(args["count"] == ".") {
		std::cout << numrec << " references printed" << std::endl;
	}
}
