#include <string>
#include <list>

using std::string;
using std::list;

#include "generator.h"

string generator::next()
{
	// Build the string from the current position.  This will be our
	// return value.
	string ret = "";
	for(int i: m_position)
		ret += m_letters[i];

	// Increment the position, which will be used to make the
	// string the next time we're called.
	list<int>::iterator i;
	for(i = m_position.begin(); i != m_position.end(); ++i) {
		if(++*i >= m_letters.length())
			*i = 0;
		else
			break;
	}
	if(i == m_position.end())
		m_position.push_back(0);

	// Return the string we made in the first loop.
	return ret;
}
