/*
 * Generate combinations of characters from a string.
 */

#ifndef _combo_h_
#define _generator_h_

#include <string>
#include <list>

using std::string;
using std::list;

class generator {
public:
	// Create a generator that will generate combinations of the
	// characters in the string letters.  Given an infinite amount
	// of time and memory, all of the infinite strings in this set will
	// be generated.
	generator(std::string letters): m_letters(letters) {
		m_position.push_back(0);
	}

	// Get the next combination, and advance the generator.
	std::string next();
private:
	// The alphabet.
	string m_letters;

	// The current position.
	list<int> m_position;
};

#endif
