#include <array>
#include <string>
#include <iostream>
#include <fstream>
#include <vector>
#include <algorithm>

#include <cctype>

using namespace std;

#include "guesser.h"

bool guesser::open(string fn)
{
	// Clear the stream (in case used previously) and open the
	// specified file.
	m_initread.clear();
	m_instream.open(fn, ios_base::binary);
	if(!m_instream) return false;

	// Find out its size.
	m_instream.seekg(0, m_instream.end);
	m_streamsize = m_instream.tellg();
	m_instream.seekg(0, m_instream.beg);
	return true;
}

guesser::guess_t guesser::guess(string key, string outfile)
{
	// Init the decrypt object
	AES decryptor(key, false);

	// Perform the short test on the guess.
	try {
		decodesome(decryptor);
	} catch(std::runtime_error &e) {
		return no;
	}
	if(!is_plain(m_inittrans)) return no;

	// Now try to translate the whole file.
	ofstream out(outfile);
	if(!out) return fail;

	// Write the test data.
	out.write(reinterpret_cast<char *>(m_inittrans.data()),
		  m_inittrans.size());

	// If the whole input file was already read, we're done.
	if(m_instream.eof()) return yes;

	// Now process the remaining file.
	array<char, 1024> inbuf;
	vector<unsigned char> outbuf;
	bool plain = true;
	do {
		m_instream.read(inbuf.data(), inbuf.size());
                int nread = m_instream.gcount();
		try {
			decryptor.crypt(inbuf,nread,outbuf, m_instream.eof() || 
					m_instream.tellg() == m_streamsize);
		} catch(std::runtime_error &e) {
			return no_but_wrote;
		}
		out.write(reinterpret_cast<char *>(outbuf.data()),
			  outbuf.size());
		plain = is_plain(outbuf);
	} while(!m_instream.eof() && plain);

	// Reset the file in case we want to try another key for any reason.
	m_instream.clear();
	m_instream.seekg(m_initread.size());

	return plain ? yes : no_but_wrote;
}

// Tell if the buffer looks plain (in printable \r\n\t range).
// If the buffer is very small (or especially if it's empty) the
// result is correct, but pretty meaningless about the correctness
// of the kesy.
bool guesser::is_plain(vector<unsigned char> &data)
{
	for(auto i = data.begin(); i != data.end(); ++i) {
		if(!isprint(*i) && *i != '\t' && *i != '\n' && *i != '\r')
			return false;
	}

	return true;
}

// Try to read an decode a leading portion of the file and decode it.
// The method fills m_initread with enough initial bytes from the
// file to create some minimal-size translation.  After the first
// call, it doesn't read the file again, but reuses the data in 
// m_initread.  The translation is placed in m_inittrans.  
void guesser::decodesome(AES &decryptor)
{
	// If there's already an initial portion, just trans it again.
	if(m_initread.size() > 0) {
		decryptor.crypt(m_initread, m_inittrans, m_instream.eof() || 
				m_initread.size() == m_streamsize);
		return;
	}

	// This the mininum number of bytes which is "enough," assuming
	// the input file is larger.
	static const int MINTEST = 20;

	// Now we have to try some reading.
	int oldsize = 0;  // How many bytes we have.
	int size = 20;	  // How many bytes we want (up to eof).
	m_inittrans.clear();
	while(true) {
		// Read the next chunk from the file.  Read the new bytes
		// into m_initread at the end of any existing data.
		// Adjust size to what was actually read, since we might
		// reach the end of the file.
		m_initread.resize(size);
		m_instream.read(reinterpret_cast<char *>
					(m_initread.data() + oldsize),
				m_initread.size() - oldsize);
		size = oldsize + m_instream.gcount();
		m_initread.resize(size);

		// Decrypt the newly-read data.
		decryptor.crypt_append(m_initread.data() + oldsize,
				       size - oldsize, m_inittrans,
				       m_instream.eof() ||
				       m_instream.tellg() == m_streamsize);
		
		// Did we get enough data (or all of it)?
		if(m_inittrans.size() > MINTEST ||
		   m_instream.tellg() == m_streamsize || m_instream.eof())
			return;

		// Double the read size and try again.
		oldsize = size;
		size *= 2;
	}
}
