#ifndef _tryguess_h_
#define _tryguess_h_

#include <string>
#include <iostream>
#include <fstream>

#include "AES.h"

class guesser {
public:
	// Open the file containing the encrypted message.
	bool open(std::string fn);

	// See if this is the key.  Assumes the key is correct if the
	// decrypted file is entirely printable characters, plus \t\n\r.
	// Attempts a short test decoding of the first part of the file.
	// If the fails, return false.  If it passes, decrypt into outfile,
	// verify that the whole thing is in the proper range, and return
	// the success.  Returns fail when something goes wrong that 
	// a new guess probably can't fix.  Yes if the output file was
	// written and looks correct, no if the fast test failed so no file
	// was written, or no_but_wrote if fast test succeeded, and something
	// was written, but the full translation fails.  This is unlikely.
	enum guess_t { yes, no, no_but_wrote, fail };
	guess_t guess(std::string key, std::string outfile);
private:
	// Tell if the buffer looks plain (in printable \r\n\t range).
	// If the buffer is very small (or especially if it's empty) the
	// result is correct, but pretty meaningless about the correctness
	// of the key.
	bool is_plain(vector<unsigned char> &data);

	// Try to read an decode a leading portion of the file and decode it.
	// The method fills m_initread with enough initial bytes from the
	// file to create some minimal-size translation.  After the first
	// call, it doesn't read the file again, but reuses the data in 
	// m_initread.  The translation is placed in m_inittrans.  
	void decodesome(AES &decryptor);

	std::ifstream m_instream;
	int m_streamsize;  // How large is the file?  Valid after open.
	std::vector<unsigned char> m_initread;  // Initial portion of file.
	std::vector<unsigned char> m_inittrans;  // Translation of initread.
};

#endif

