/*
 * Single-thread key guesser.
 */
#include <iostream>
#include <cstdlib>
#include <string>

using namespace std;

#include "guesser.h"
#include "generator.h"

// Call as "pgm filename"
int main(int argc, char **argv)
{
	if(argc != 2) {
		cout << "Usage: " << argv[0] << " encryptedfile" << endl;
		exit(1);
	}

	// Create the guesser object, and open the encrypted file.
	guesser trythis;
	if(!trythis.open(argv[1])) {
		cout << "Unable to read " << argv[1] << endl;
		exit(2);
	}

	// Count them.
	int nkey = 0;

	// Try keys until something works.  Don't hold your breath.
	generator gen("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
		      "0123456789");
	string outfile = argv[1] + string(".plain");
	while(true) {
		string keyguess = gen.next();
		guesser::guess_t res = trythis.guess(keyguess, outfile);
		if(res == guesser::no || res == guesser::no_but_wrote) {
			if((++nkey & 0xffff) == 0) {
				cout << nkey << " keys; current "
				     << keyguess << endl;
			}
			continue;
		} else if(res == guesser::yes) {
			cout << "The key is " << keyguess << ", " 
			     << ++nkey << " keys guessed." << endl;
			exit(0);
		} else {
			cout << "Unable to process guess " << keyguess << endl;
			exit(1);
		}
	}
}
